﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Runtime.Hosting;
using System.IO;





/*  
    Windows Workflow Foundation Persistence services    

    WorkflowPersistenceService
    SqlWorkflowPersistenceService
    Creating custom persistence services

    This example uses either the predefined SqlWorkflowPersistenceService persistence service class
    or a custom persistence service class, the CustomPersistenceService class.
    The CustomPersistenceService class save worklows to binary disk files.

    To control the type of the service to use, use the boolean parameter of the 
    CreatePersistenceService() private method. 

    For this application to work properly, when the SqlWorkflowPersistenceService is used, 
    a local MS SQL server database must created. Use the sql scripts
        SqlPersistenceService_Schema.sql and
        SqlPersistenceService_Logic.sql
    found at <%WINDIR%>\Microsoft.NET\Framework\v3.0\Windows Workflow Foundation\SQL
    to create the database schema and stored procedures. Name the database WorkflowStore.


    The workflow starts execution, it then sleeps for 3 seconds and then resumes execution.
    Clicking on the "Save Workflow" button, after the "Start", the workflow is written to
    the database and then it is unloaded from the memory. Clicking the "Load Workflow" button
    loads the workflow from the database and continues execution. 
 
 */
namespace Lessons.Workflows
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        delegate void InfoDelegate(string Text);
        private delegate void WorkflowDoneDelegate();


        WorkflowRuntime workflowRuntime = null;
        WorkflowInstance instance = null;

        /* adds the Text to the ListBox in a synchronized manner */
        public void ProcessInfo(string Text)
        {
            if (this.InvokeRequired)
            {
                /* if synchronization is required, then re-call itself through an invoked delegate */
                InfoDelegate d = delegate(string s) { ProcessInfo(s); };
                this.Invoke(d, Text);
            }
            else
            {
                this.lboInfo.Items.Add(Text);
            }  
        }


        /* arrange the user interface upon workflow termination, in a synchronized manner */
        private void WorkflowDone()
        {
            if (this.InvokeRequired)
            {
                WorkflowDoneDelegate d = delegate() { WorkflowDone(); };
                this.Invoke(d);
            }
            else
            {
                btnStartWorkflow.Enabled = true;
                lboInfo.Items.Add("-----------");
            }
        }

 
        /* creates a persistence service according to a passed flag */
        WorkflowPersistenceService CreatePersistenceService(bool custom)
        {
            if (custom)
            {
                string Folder = Path.GetDirectoryName(Application.ExecutablePath);
                return new CustomPersistenceService(Folder);
            }
            else
            {
                string ConString = @"Data Source=localhost; Initial Catalog=WorkflowStore;Integrated Security=True;";
                return new SqlWorkflowPersistenceService(ConString);
            }
        }



        private void MainForm_Load(object sender, EventArgs e)
        { 
            workflowRuntime = new WorkflowRuntime();
 
            workflowRuntime.WorkflowCompleted += new EventHandler<WorkflowCompletedEventArgs>(WorkflowCompleted);
            workflowRuntime.WorkflowTerminated += new EventHandler<WorkflowTerminatedEventArgs>(WorkflowTerminated);

 
            ExternalDataExchangeService ExchangeService = new ExternalDataExchangeService();
            workflowRuntime.AddService(ExchangeService);
            WorkflowInfo workflowInfo = new WorkflowInfo(this);
            ExchangeService.AddService(workflowInfo);

            /* create the WorkflowPersistenceService and register it with the WWF runtime engine */
            workflowRuntime.AddService(CreatePersistenceService(false));
 
        }

        void WorkflowCompleted(object sender, WorkflowCompletedEventArgs e)
        {
            WorkflowDone();
        }

        void WorkflowTerminated(object sender, WorkflowTerminatedEventArgs e)
        {
            WorkflowDone();
        }

        private void btnStartWorkflow_Click(object sender, EventArgs e)
        {
            btnStartWorkflow.Enabled = false;
            btnSaveWorkflow.Enabled = true;
            btnLoadWorkflow.Enabled = false;
            
            instance = workflowRuntime.CreateWorkflow(typeof(Lessons.Workflows.Workflow1));
            instance.Start();
        }

        private void btnSaveWorkflow_Click(object sender, EventArgs e)
        {
            btnSaveWorkflow.Enabled = false;
            try
            {
                instance.Unload();  // Unload() blocks execution if the workflow is not in an idle state
                btnLoadWorkflow.Enabled = true;
            } 
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            } 
        }

        private void btnLoadWorkflow_Click(object sender, EventArgs e)
        {

            btnLoadWorkflow.Enabled = false;
            try
            {
                instance.Load();
            }  
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }  
 
            btnStartWorkflow.Enabled = true;
        }

        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            workflowRuntime.Dispose();
        }


    }
}





namespace Lessons.Workflows
{

    /* a class implementing the contract interface. Only one implementation is allowed */
    public class WorkflowInfo : IWorkflowInfo
    {
        MainForm form;

        public WorkflowInfo(MainForm Form)
        {
            form = Form;
        }

        public void InformHost(string Text)
        {
            form.ProcessInfo(Text);
        }
    }


}